import { http } from '@inside-library/helpers/Http'

const getTabSpacePageParams = async ({
  data,
  uuid,
  endpoint,
  additionalFields,
  isQuery
}) => {
  try {
    const { data: category } = await http.get(`content/${endpoint}`, {
      fields: ['uuid', 'slug', additionalFields],
      filters: { 'uuid:eq': uuid || data.uuid }
    })

    const findObjectKeys = (obj, path = '') => {
      let result = null

      for (let key in obj) {
        if (typeof obj[key] === 'object') {
          const newPath = path !== '' ? `${path}.${key}` : key
          if (!Array.isArray(obj[key]) && Object.keys(obj[key]).length > 0) {
            result = newPath
          }
          const innerResult = findObjectKeys(obj[key], newPath)
          if (innerResult) {
            result = innerResult
          }
        }
      }

      return result
    }

    const pathParts = findObjectKeys(additionalFields)
      .split('.')
      .filter(part => !/^\d+$/.test(part))

    let value = category[0]

    for (const part of pathParts) {
      value = value && value[part]
    }

    const params = {
      name: 'TabSpacePage',
      params: {
        slug: value?.slug?.[0]
      }
    }

    if (isQuery) {
      params.query = { page: uuid || data.uuid }
    }

    return params
  } catch (err) {
    return { path: '/' }
  }
}

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  pagesCategories: {
    add: async ({ data, uuid }) => {
      const params = await getTabSpacePageParams({
        data,
        uuid,
        endpoint: 'pages_categories',
        additionalFields: {
          spaces: {
            fields: ['uuid', 'title', 'slug']
          }
        },
        isQuery: false
      })

      return params
    },
    delete: async ({ data, uuid }) => {
      const params = await getTabSpacePageParams({
        data,
        uuid,
        endpoint: 'pages_categories',
        additionalFields: {
          spaces: {
            fields: ['uuid', 'title', 'slug']
          }
        },
        isQuery: false
      })

      return params
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spacesPages: {
    add: async ({ data, uuid }) => {
      const params = await getTabSpacePageParams({
        data,
        uuid,
        endpoint: 'spaces_pages',
        additionalFields: {
          pages_categories: [
            'uuid',
            'title',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ]
        },
        isQuery: true
      })

      return params
    },
    delete: async ({ data, uuid }) => {
      const params = await getTabSpacePageParams({
        data,
        uuid,
        endpoint: 'spaces_pages',
        additionalFields: {
          pages_categories: [
            'uuid',
            'title',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ]
        },
        isQuery: false
      })

      return params
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  agencies: {
    add: () => ({
      name: 'MapPage'
    }),
    delete: () => ({
      name: 'MapPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  }
}
