<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'events',
            'registration_enabled',
            [
                'name' => 'registration_enabled',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Activer l\'inscription aux événements',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            15
        );

        $this->migrateContent('modals');
        $this->finishUp();
    }
}
