<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => 'Les actualités Qualibat',
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => 'Les prochains évènements',
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => 'Les équipes Qualibat',
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => 'Base documentaire',
                'introduction' => 'Retrouvez tous les documents, photos, fiches pratiques…',
            ],
            [
                'custom_slug' => 'spaces',
                'redirection_page' => 'SpacesListingPage',
                'title' => 'Espaces services',
            ],
            [
                'title' => 'Implantations',
                'introduction' => 'Nous sommes présents sur plusieurs lieux. Cliquez sur chaque point pour en découvrir les spécificités.',
                'custom_slug' => 'map',
                'redirection_page' => 'MapPage',
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => 'Tous vos outils en 1 clic !',
            ],
            [
                'title' => 'Questions les plus fréquentes',
                'introduction' => 'Retrouvez toutes les réponses à vos questions',
                'custom_slug' => 'faq',
                'redirection_page' => 'FAQListingPage',
            ],
            [
                'title' => 'Mouvements',
                'custom_slug' => 'newcomers',
                'redirection_page' => 'NewcomersListingPage',
            ],
        ]);

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge) {
            $existing = Custom::where('redirection_page', $custom['redirection_page'])->first();

            if ($existing instanceof Custom) {
                $custom['uuid'] = $existing->uuid;
            }

            $bridge->contentInsert('custom', $custom, ! isset($custom['uuid']));
        });
    }
}
