<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'mood_bill',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Billet d’humeur.',
        ],
    ],
    'fields' => [
        [
            'name' => 'wysiwyg',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'headband_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Couleur de bandeau',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
