<?php

use Inside\Host\Bridge\BridgeContent;

if (! function_exists('get_entity_reference')) {
    function get_entity_reference(?string $value, string $contentType, BridgeContent $bridge, string $identifier = 'title', bool $create = true): ?string
    {
        if (empty($value)) {
            return null;
        }

        $existing = type_to_class($contentType)::where($identifier, $value)->first()?->uuid;

        if (! $create) {
            return $existing;
        }

        return $existing ?? $bridge->contentInsert($contentType, [$identifier => $value]);
    }
}

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'functions' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($user->jobTitle, 'functions', $bridge),
        'delegations' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($user->department, 'delegations', $bridge),
        'companies' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($user->companyName, 'companies', $bridge),
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? null,
        'status' => fn () => true,
        'is_maintenance' => fn () => false,
    ],
];
