<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateUsersContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('companies');
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'agencies');
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'users',
            'companies',
            [
                'name' => 'companies',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 7,
                'title' => [
                    'fr' => 'Agence',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['companies'],
                    'cardinality' => 1,
                ],
            ]
        );
        $this->finishUp();
    }
}
