<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

final class CreateMoodBill extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('mood_bill');

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'events',
            'background_image',
            [
                'name' => 'background_image',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Image de fond',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        $this->getBridge()?->updateContentTypeOptions('tools', ['listing_type' => 'hidden']);
        $this->getBridge()?->updateContentTypeOptions('tools_categories', ['listing_type' => 'taxo']);

        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'tools');

        $this->finishUp();
    }
}
