export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    props: {
      extraFields: ['total_views', 'unique_views']
    }
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: {
      extraFields: ['total_views', 'unique_views']
    }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      extraFields: ['total_views', 'unique_views'],
      filtersInput: 'selectbox'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      extraFields: ['total_views', 'unique_views']
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'BirthdaysListingPage',
    meta: { disabled: true }
  },
  {
    name: 'WorkAnniversariesListingPage',
    meta: { disabled: false }
  }
]
