export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'image',
      'lastname',
      'email',
      'phone',
      'function',
      {
        manager: {
          fields: ['uuid', 'firstname', 'lastname', 'function', 'image', { entities: ['uuid', 'title'] }],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0
          }
        }
      },
      { entities: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      {
        'users.manager': {
          fields: ['firstname', 'lastname', 'uuid', 'function', 'image', { entities: ['uuid', 'title'] }],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            alias: 'coworkers'
          }
        }
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
