<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;

final class EditDefaultToolsForPrae extends Migration
{
    public function up(): void
    {
        $defaultTools = [
            'Praemia REIM | Site corporate - preim-com - Praemia REIM' => 0,
            'Praemia REIM Group LinkedIn account' => 1,
            'Salesforce' => 2,
            'DocuSign' => 3,
            'Egencia' => 4,
        ];

        $defaultToolsCategory = 'Primonial REIM';

        $languages = list_languages();

        foreach ($languages as $language) {
            $existingTools = Tools::query()
                ->whereIn('title', array_keys($defaultTools))
                ->where('langcode', $language)
                ->get()
                ->sortBy(fn ($tool) => $defaultTools[$tool->title])
                ->pluck('title')
                ->toArray();

            $toolsToCreate = array_diff(array_keys($defaultTools), $existingTools);

            $toolsCategory = ToolsCategories::where('title', $defaultToolsCategory)->where('langcode', $language)->first();
            if (!$toolsCategory) {
                $bridge = new BridgeContent();
                $toolsCategory = $bridge->contentUpdate(
                    type: 'tools_categories',
                    data: [
                        'title' => $defaultToolsCategory,
                        'langcode' => $language,
                    ]
                );
            }

            $bridge = new BridgeContent();
            collect($toolsToCreate)->each(function ($title) use ($bridge, $defaultTools, $toolsCategory, $language) {
                $bridge->contentUpdate(
                    type: 'tools',
                    data: [
                        'title' => $title,
                        'weight' => $defaultTools[$title],
                        'langcode' => $language,
                        'tools_categories' => [
                            'target_uuid' => $toolsCategory->uuid,
                        ],
                    ]
                );
            });
        }

        $bridgeContentType = new BridgeContentType();

        $allTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title]);

        $defaultToolsUuids = $allTools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );
    }
}
