<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

final class EnableSeniorityAnniversary extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        Artisan::call('db:seed', [
            '--class' => 'Inside\\Content\\Seeders\\SeniorityAnniversarySeeder',
        ]);

        Artisan::call('db:seed', [
            '--class' => 'Inside\\Notify\\Seeders\\SeniorityAnniversaryNotificationSeeder',
        ]);
    }
}
