<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Bridge\BridgeContentType;

class MultipleReferences extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();
        collect(['services','entities','locations'])
          ->each(
              function (string $contentType) use ($bridge) {
                  $bridge->updateFieldOptions(
                      type: 'users',
                      fieldName: $contentType,
                      options: [
                        'settings' => [
                          'target_type' => [$contentType],
                          'cardinality' => -1,
                        ]
                      ]
                  );
                  $bridge->switchCardinalityFromUnaryToMultiple('users', $contentType, true);
              }
          );
    }
}
