<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'cards_links',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Image avec lien',
            'en' => 'Image with link'
        ],
    ],
    'fields' => [
        [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Remonter en haut de la page d’accueil',
                'en' => 'Go back to the top of the home page',
            ],
            'description' => [
                'fr' => "Si coché, cette carte sera affichée en haut de la page d’accueil.",
                'en' => "If checked, this card will be displayed at the top of the home page.",
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
