<?php

use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'mail' => 'userPrincipalName',
        'name' => 'userPrincipalName',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'manager' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst($user->department))
            ->get(),
        'entities' => fn (mixed $user) => reference('entities')
            ->identifiedBy('code')
            ->from(ucfirst($user->companyName))
            ->get(),
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from(ucfirst($user->state))
            ->get(),
        'phone' => 'mobilePhone',
        'langcode' => fn (mixed $user) => Users::where('email', $user->userPrincipalName)->first()?->langcode ?? 'fr',
        'seniority_anniversary' => fn (mixed $user) => carbonize('d/m/Y')->from($user->extension_48761a6bb4bf443b9fdd794bc2c1832a_msDS_cloudExtensionAttribute10)->birthday(),
        'status' => fn () => 1
    ],
    'custom_attributes' => [
        'manager' => 'userPrincipalName',
    ]
];
