<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateContentType extends Migration
{
    use CreateContentTypes;

    private const CONTENT_TYPE = 0;
    private const TITLE = 1;
    private const GLOBAL_SEARCHABLE = 2;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        $contentTypes = [
          ['services', ['fr' => 'Service', 'en' => 'Service'], false],
          ['entities', ['fr' => 'Entité', 'en' => 'Entity'], false],
          ['locations', ['fr' => 'Localisation', 'en' => 'Location'], false],
          ['tools_categories', ['fr' => 'Catégorie d\'outil', 'en' => 'Tool category'], false],
          ['tools', ['fr' => 'Outil', 'en' => 'Tool'], true],
          ['news_categories', ['fr' => 'Catégorie d\'actualité', 'en' => 'News Category'], false],
          ['news', ['fr' => 'Actualité', 'en' => 'News'], true],
          ['events_categories', ['fr' => 'Catégorie d\'événement', 'en' => 'Event category'], false],
          ['events', ['fr' => 'Événement', 'en' => 'Event'], true],
          ['folders', ['fr' => 'Dossier', 'en' => 'Folder'], true],
          ['documents', ['fr' => 'Document', 'en' => 'Document'], true],
          ['blocks', ['fr' => 'Bloc', 'en' => 'Block'], false],
          ['tabs_spaces', ['fr' => 'Espace à onglets', 'en' => 'Tab spaces'], false],
          ['tabs', ['fr' => 'Onglet', 'en' => 'Tab'], false],
          ['tabs_pages', ['fr' => 'Sous Page Onglet', 'en' => 'Sub Page Tab'], true],
          ['cards_links', ['fr' => 'Image avec lien', 'en' => 'Image with link'], false],
          ['faq_categories', ['fr' => 'Catégorie FAQ', 'en' => 'FAQ category'], true],
          ['faq_questions', ['fr' => 'Question FAQ', 'en' => 'Question FAQ'], false],
          ['flash_news', ['fr' => 'Flash info', 'en' => 'Flash info'], false],
          ['users', ['fr' => 'Utilisateur', 'en' => 'User'], false],
        ];

        $this->bootUp(__FILE__);

        foreach ($contentTypes as $contentType) {
            $bridge->updateContentTypeOptions($contentType[self::CONTENT_TYPE], [
              'name' => $contentType[self::CONTENT_TYPE],
              'translatable' => true,
              'title' => $contentType[self::TITLE],
              'global_searchable' => $contentType[self::GLOBAL_SEARCHABLE]
            ]);
        }

        $this->finishUp();
        $this->call("models:rebuild");
    }
}
