<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

class CreateContentType extends Migration
{
    use CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('services', false);
        $this->migrateContent('entities', false);
        $this->migrateContent('locations', false);
        $this->migrateContent('tools_categories', false);
        $this->migrateContent('tools', false);
        $this->migrateContent('users', false);
        $this->migrateContent('news_categories', false);
        $this->migrateContent('news', false);
        $this->migrateContent('events_categories', false);
        $this->migrateContent('events', false);
        $this->migrateContent('folders', false);
        $this->migrateContent('documents', false);
        $this->migrateContent('blocks', false);
        $this->migrateContent('tabs_spaces', false);
        $this->migrateContent('tabs', false);
        $this->migrateContent('tabs_pages', false);
        $this->migrateContent('cards_links', false);

        ContentBlueprints::generateContent(contentType: 'faq_categories');
        ContentBlueprints::generateContent(contentType: 'faq_questions');
        ContentBlueprints::generateContent(contentType: 'flash_news');
        $this->finishUp();
    }
}
