import PPPage from '../pages/pp/PPPage'
import { fetchPP, fetchPPFrance } from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import dashboardAccess from '../guards/dashboard-access'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'PPPage',
    path: {
      fr: '/policies-procedures/:slug',
      en: '/policies-procedures/:slug'
    },
    component: withFetch(PPPage, { size: 'xxl', watch: true })(fetchPP),
    meta: { content: 'p_and_p' }
  },
  {
    name: 'PPFrenchPage',
    path: {
      fr: '/policies-procedures-france/:slug',
      en: '/french-policies-procedures/:slug'
    },
    component: withFetch(PPPage, { size: 'xxl', watch: true })(fetchPPFrance),
    meta: { content: 'p_and_p_france' }
  },
  {
    name: 'PPSetUser',
    path: {
      fr: '/pp-choix-utilisateur/:uuid',
      en: '/pp-set-user/:uuid'
    },
    alias: '/pp-set-user/:uuid',
    component: () => import('../components/pp/forms/PPUserFormBuilder')
  },
  {
    name: 'DashboardPage',
    path: {
      fr: '/tableau-de-bord',
      en: '/dashboard'
    },
    component: () => import('../pages/dashboard/DashboardPage'),
    beforeEnter: (to, from, next) => dashboardAccess({ next })
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
