import { http } from '@inside-library/helpers/Http'

export const fetchPP = async ({ $route }) => {
  try {
    const { data } = await http.get('content/p_and_p', {
      fields: [
        'uuid',
        'admin',
        'last_update',
        'definition',
        'policy',
        'archived',
        'title',
        'total',
        'content_type',
        'slug',
        'updated_at',
        'created_at',
        'status',
        'content',
        {
          brands: ['uuid', 'title', 'logo', 'image']
        },
        {
          management_modes: ['uuid', 'title']
        },
        {
          p_and_p_categories: ['title', 'count']
        },
        {
          contact: ['uuid', 'firstname', 'lastname', 'image', 'email']
        }
      ],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    const regions = await http.get('content/p_and_p_regions', {
      fields: [
        'uuid',
        'admin',
        {
          contact: ['uuid', 'firstname', 'lastname', 'image', 'email']
        },
        {
          regional_offices: ['uuid', 'title']
        }
      ],
      filters: {
        p_and_p: {
          'slug:eq': $route.params.slug
        }
      }
    })

    return { data: data[0], regions: regions.data }
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchPPFrance = async ({ $route }) => {
  try {
    const { data } = await http.get('content/p_and_p_france', {
      fields: [
        'uuid',
        'admin',
        'last_update',
        'definition',
        'policy',
        'archived',
        'title',
        'total',
        'content_type',
        'slug',
        'updated_at',
        'created_at',
        'status',
        'content',
        {
          brands: ['uuid', 'title', 'logo', 'image']
        },
        {
          management_modes: ['uuid', 'title']
        },
        {
          p_and_p_categories: ['title', 'count']
        },
        {
          contact: ['uuid', 'firstname', 'lastname', 'image', 'email']
        }
      ],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    return { data: data[0] }
  } catch (err) {
    throw new Error(err)
  }
}
