<?php

declare(strict_types=1);

namespace Inside\PPLH\Services;

use Inside\Content\Models\Contents\PAndP;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Content\Models\Contents\RegionalOffices;
use Inside\PPLH\Contracts\PAndPRegionsGenerator as PAndPRegionsGeneratorContract;
use Inside\PPLH\Services\Traits\HasBridgeContent;

class PAndPRegionsGenerator implements PAndPRegionsGeneratorContract
{
    use HasBridgeContent;

    public function createOrUpdatePAndPRegion(PAndP $pp, RegionalOffices $regionalOffice): void
    {
        $existingRegion = $pp->reversePAndPRegions->first(fn (PAndPRegions $test) => $test->regionalOffices->pluck('uuid')->contains($regionalOffice->uuid));

        $region = [
            'type' => 'node',
            'bundle' => 'p_and_p_regions',
            'langcode' => $pp->langcode,
            'title' => "$pp->title : $regionalOffice->title",
            'p_and_p' => [$pp->uuid],
            'regional_offices' => [$regionalOffice->uuid],
        ];

        if ($existingRegion instanceof PAndPRegions) {
            $region['uuid'] = $existingRegion->uuid;
        }

        $this->getBridgeContent()->contentInsert('p_and_p_regions', $region, is_null($existingRegion), true);
    }

    public function generateForPAndP(PAndP $pp): void
    {
        RegionalOffices::where('langcode', $pp->langcode)->get()->each(fn (RegionalOffices $regionalOffice) => $this->createOrUpdatePAndPRegion($pp, $regionalOffice));
    }

    public function generateFromRegionOffice(RegionalOffices $regionalOffice): void
    {
        PAndP::where('langcode', $regionalOffice->langcode)->get()->each(fn (PAndP $pp) => $this->createOrUpdatePAndPRegion($pp, $regionalOffice));
    }

    public function cleanPAndPOrphanRegions(): void
    {
        PAndPRegions::doesntHave('pAndP')->each(fn (PAndPRegions $region) => $this->getBridgeContent()->contentDelete($region->content_type, $region->uuid));
    }

    public function cleanRegionalOfficeOrphanRegions(): void
    {
        PAndPRegions::doesntHave('regionalOffices')->each(fn (PAndPRegions $region) => $this->getBridgeContent()->contentDelete($region->content_type, $region->uuid));
    }
}
