<?php

declare(strict_types=1);

namespace Inside\PPLH\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Inside\User\Models\User;

/**
 * @property string $user_uuid
 * @property string $content_uuid
 * @property User $user
 * @method static static firstOrCreate($data)
 * @method static Builder whereIn($column, $values, $boolean = 'and', $not = false);
 */
class PAndPContact extends Model
{
    protected $table = 'pplh_p_and_p_contacts';

    public $timestamps = false;

    protected $fillable = [
        'user_uuid',
        'content_uuid',
    ];

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'uuid', 'user_uuid');
    }
}
