<?php

declare(strict_types=1);

namespace Inside\PPLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Models\Contents\PAndP;
use Inside\Content\Models\Contents\RegionalOffices;
use Inside\PPLH\Contracts\PAndPRegionsGenerator;

class RegionsParentsDeletedListener implements ShouldQueue
{
    public function __construct(private PAndPRegionsGenerator $regionsGenerator)
    {
    }

    public function handle(ContentDeletedEvent $event): void
    {
        $model = $event->model;

        if ($model instanceof PAndP) {
            $this->regionsGenerator->cleanPAndPOrphanRegions();
        }

        if ($model instanceof RegionalOffices) {
            $this->regionsGenerator->cleanRegionalOfficeOrphanRegions();
        }
    }
}
