<?php

declare(strict_types=1);

namespace Inside\PPLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\PAndP;
use Inside\PPLH\Contracts\PAndPRegionsGenerator;

class PAndPInsertedListener implements ShouldQueue
{
    public function __construct(
        private PAndPRegionsGenerator $regionsGenerator
    ) {
    }

    public function handle(ContentInsertedEvent | ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof PAndP) {
            return;
        }

        $user = User::find($model->author_id);

        // if the author is not super admin, we wait the Workflow resolution to generate the regions
        if (! $user instanceof User || ! $user->isSuperAdmin()) {
            return;
        }

        $this->regionsGenerator->generateForPAndP($model);
    }
}
