<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;

class DeletePAndPRegionsDuplicates extends Migration
{
    use HasConsole;

    private function deleteDuplicates(BridgeContent $bridge): void
    {
        $this->getOutput()->writeln("getting duplicates to delete ...");
        $allRegions = PAndPRegions::whereHas('pAndP')->where('langcode', 'fr')->get();
        $unique = $allRegions->unique(['title']);

        $duplicates = $allRegions->diff($unique)->map(
            fn ($region) => PAndPRegions::where('title', $region->title)
            ->where('langcode', 'fr')
            ->where('uuid', '!=', $region->uuid)
            ->whereHas('pAndP', fn ($query) => $query->where('uuid', $region->pAndP->first()?->uuid))
            ->get()
            ->pluck('uuid')
        )->flatten();

        if ($duplicates->isEmpty()) {
            $this->getOutput()->writeln("every duplicates has been deleted");
            return;
        }

        $this->getOutput()->writeln("trying to delete {$duplicates->count()} duplicates");

        $duplicates->each(function (string $uuid) use ($bridge) {
            $bridge->contentDelete('p_and_p_regions', $uuid);
        });

        $this->getOutput()->writeln("done with this batch of delete ... checking again if everything has been correctly deleted ...");

        $this->deleteDuplicates($bridge);
    }

    public function up(): void
    {
        $bridge = new BridgeContent();

        $this->deleteDuplicates($bridge);
    }
}
