<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddNotificationTypes extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p_regions'),
                'action' => 'p_and_p_region_created',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.region.title',
                    'description' => 'notifications.p_and_p.region.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.region.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p_regions'),
                'action' => 'p_and_p_region_assigned',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.region_assigned.title',
                    'description' => 'notifications.p_and_p.region_assigned.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.region_assigned.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p'),
                'action' => 'p_and_p_updated',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.updated.title',
                    'description' => 'notifications.p_and_p.updated.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.updated.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p'),
                'action' => 'p_and_p_published',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.published.title',
                    'description' => 'notifications.p_and_p.published.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.published.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p'),
                'action' => 'p_and_p_updated_manager',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.updated.title',
                    'description' => 'notifications.p_and_p.updated.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.updated.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p'),
                'action' => 'p_and_p_email',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => null,
            ]
        );
        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p_regions'),
                'action' => 'p_and_p_region_changed',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.region_changed.title',
                    'description' => 'notifications.p_and_p.region_changed.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.region_changed.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => type_to_class('p_and_p'),
                'action' => 'p_and_p_updated_lhg',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.p_and_p.updated_lhg.title',
                    'description' => 'notifications.p_and_p.updated_lhg.description',
                    'icon' => 'p_and_p',
                    'text' => 'notifications.p_and_p.updated_lhg.text',
                    'fields' => ['title'],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'type' => 'system',
                'default' => false,
                'event' => null,
                'model' => null,
                'action' => 'export',
                'condition' => null,
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.content.export.title',
                    'description' => 'notifications.content.export.description',
                    'text' => 'notifications.content.export.text',
                ],
            ]
        );
    }
}
