<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'p_and_p_france',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Policies and procedures (France)',
            'en' => 'Policies and procedures (France)',
        ],
    ],
    'fields' => [
        [
            'name' => 'p_and_p_categories',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Catégorie',
                'en' => 'Category',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['p_and_p_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'definition',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Definition',
                'en' => 'Definition',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'policy',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Politique',
                'en' => 'Policy',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'contact',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Contact LHG',
                'en' => 'LHG contact',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 7,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'management_modes',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 10,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 11,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 11,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'last_update',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Dernière mise à jour',
                'en' => 'Last update',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'reviewed',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 13,
            'title' => [
                'fr' => 'Déjà relue par un administrateur ?',
                'en' => 'Already reviewed by an admin ?',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 13,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
