<?php

declare(strict_types=1);

use Inside\Content\Models\Contents\Users;

return [
    'types' => [
        'p_and_p' => [
            'category' => 'p_and_p_categories',
            'comments' => false,
            'likes' => false,
        ],
    ],
    'export' => [
        'contents' => [
            'headers' => [
                'uuid' => 'UUID',
                'content_type' => 'Content type',
                'title' => 'Title',
                'edit' => 'Edit link',
            ],
            'presenters' => [
                'edit' => static fn ($value, $model) => env('APP_URL').'/edit/'.class_to_type($model).'/'.$model->uuid,
            ],
        ],
        'users' => [
            'headers' => [
                'email' => 'Mail address',
                'full_name' => 'Full name',
                'fra_code' => 'FRA Code',
            ],
            'presenters' => [
                'fra_code' => function ($value, $model) {
                    $user = Users::find($model->user_uuid);

                    return $user?->fra_code;
                },
            ],
        ],
        'user_visits' => [
            'headers' => [
                'user.fra_code' => 'FRA Code',
            ],
        ],
        'authentication' => [
            'headers' => [
                'fra_code' => 'FRA Code',
            ],
            'presenters' => [
                'fra_code' => function ($value, $model) {
                    $user = Users::find($model->uuid);

                    return $user?->fra_code;
                },
            ],
        ],
    ],
];
