<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\PAndPRegions;

return [
    'custom_permissions' => [
        function ($action, $type, $uuid) {
            if ($type !== 'p_and_p_regions') {
                return false;
            }

            /** @var User $user */
            $user = Auth::user();

            $model = PAndPRegions::find($uuid);

            if (! $model instanceof PAndPRegions) {
                return false;
            }

            $manager = $model->regionalOffices->first()?->manager->first();

            return $manager?->uuid === $user->uuid;
        },
    ],
    'special_roles' => ['Régions', 'Business Unit', 'Siège', 'webmaster'],
    'in_add_list' => [
        fn (string $typeClass) => in_array(class_to_type($typeClass), [
            'brands',
            'countries',
            'management_modes',
            'business_units',
            'profiles',
        ]),
    ],
];
