<?php

declare(strict_types=1);

namespace Inside\PPLH\Providers;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Notify\Events\NotificationCreatedEvent;
use Inside\PPLH\Contracts\PAndPRegionsGenerator as PAndPRegionsGeneratorContract;
use Inside\PPLH\Events\PAndPCSVGeneratedEvent;
use Inside\PPLH\Http\Middlewares\PandPRegionsPermissionsMiddleware;
use Inside\PPLH\Listeners\PAndPCSVGeneratedListener;
use Inside\PPLH\Listeners\PAndPFranceReviewedListener;
use Inside\PPLH\Listeners\PAndPInsertedListener;
use Inside\PPLH\Listeners\PAndPNotificationCreatedListener;
use Inside\PPLH\Listeners\PAndPRegionCreatedListener;
use Inside\PPLH\Listeners\PAndPRegionUpdatedListener;
use Inside\PPLH\Listeners\PAndPReviewedListener;
use Inside\PPLH\Listeners\RegionalOfficeInsertedListener;
use Inside\PPLH\Listeners\RegionsParentsDeletedListener;
use Inside\PPLH\Services\PAndPRegionsGenerator;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\Workflow\Events\ProposalReviewedEvent;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentInsertedEvent::class => [
            PAndPInsertedListener::class,
            RegionalOfficeInsertedListener::class,
            PAndPRegionCreatedListener::class,
        ],
        ContentUpdatedEvent::class => [
            PAndPInsertedListener::class,
            RegionalOfficeInsertedListener::class,
            PAndPRegionUpdatedListener::class,
        ],
        ContentDeletedEvent::class => [
            RegionsParentsDeletedListener::class,
        ],
        NotificationCreatedEvent::class => [
            PAndPNotificationCreatedListener::class,
        ],
        PAndPCSVGeneratedEvent::class => [
            PAndPCSVGeneratedListener::class,
        ],
        ProposalReviewedEvent::class => [
            PAndPReviewedListener::class,
            PAndPFranceReviewedListener::class,
        ],
    ];

    public array $bindings = [
        PAndPRegionsGeneratorContract::class => PAndPRegionsGenerator::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/contents.php', 'contents');
            $this->mergeConfigTo(__DIR__.'/../../config/louvrehotels.php', 'louvrehotels');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/workflow.php', 'workflow');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }

        $this->app->middleware([PandPRegionsPermissionsMiddleware::class]);
    }
}
