<?php

declare(strict_types=1);

namespace Inside\PPLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\RegionalOffices;
use Inside\PPLH\Contracts\PAndPRegionsGenerator;

class RegionalOfficeInsertedListener implements ShouldQueue
{
    public function __construct(
        private PAndPRegionsGenerator $regionsGenerator
    ) {
    }

    public function handle(ContentInsertedEvent | ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof RegionalOffices || $model->langcode !== config('app.locale')) {
            return;
        }

        $this->regionsGenerator->generateFromRegionOffice($model);
    }
}
