<?php

declare(strict_types=1);

namespace Inside\PPLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class PAndPRegionCreatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentInsertedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof PAndPRegions || $model->contact->isNotEmpty()) {
            return;
        }

        $pAndP = $model->pAndP()->first();
        if ($pAndP && !$pAndP->status) {
            return;
        }

        $manager = User::find($model->regionalOffices->first()?->manager?->first()?->uuid);

        if (! $manager instanceof User) {
            return;
        }

        $type = NotificationType::query()
            ->where('type', 'system')
            ->where('model', PAndPRegions::class)
            ->where('action', 'p_and_p_region_created')
            ->first();

        if (! $type instanceof NotificationType) {
            return;
        }

        $this->route = $manager;
        $this->notify($type, $manager, $model, ['url' => 'pp-set-user/'.$model->uuid, 'title' => $model->title]);
    }
}
