<?php

declare(strict_types=1);

namespace Inside\PPLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\PPLH\Events\PAndPCSVGeneratedEvent;

class PAndPCSVGeneratedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(PAndPCSVGeneratedEvent $event): void
    {
        $types = NotificationType::where('action', 'export')->get();
        $user = User::find($event->uuid);

        if (! $user instanceof User) {
            return;
        }

        $fileDownloadUrl = Storage::disk('protected')->url($event->filePath);

        /** @var NotificationType $type */
        foreach ($types as $type) {
            $this->route = $user;
            $this->when = $this->getInterval($type);
            $this->notify(
                $type,
                $user,
                null,
                [
                    'extra' => [
                        'link' => $fileDownloadUrl,
                    ],
                ],
            );
        }
    }
}
