<?php

declare(strict_types=1);

namespace Inside\PPLH\Contracts;

use Inside\Content\Models\Contents\PAndP;
use Inside\Content\Models\Contents\RegionalOffices;

interface PAndPRegionsGenerator
{
    public function createOrUpdatePAndPRegion(PAndP $pp, RegionalOffices $regionalOffice): void;

    public function generateForPAndP(PAndP $pp): void;

    public function generateFromRegionOffice(RegionalOffices $regionalOffice): void;

    public function cleanPAndPOrphanRegions(): void;

    public function cleanRegionalOfficeOrphanRegions(): void;
}
