<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Models\Contents\PAndP;
use Inside\PPLH\Models\PAndPContact;

class CreatePAndPContactsTable extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('pplh_p_and_p_contacts');
        Schema::create('pplh_p_and_p_contacts', function (Blueprint $table) {
            $table->uuid('content_uuid');
            $table->uuid('user_uuid');
            $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
        });

        $pps = PAndP::all();
        $ppsFrance = PAndP::all();

        $contents = $pps->merge($ppsFrance);

        foreach ($contents as $content) {
            $contacts = $content->contact;

            foreach ($contacts as $contact) {
                PAndPContact::firstOrCreate([
                    'user_uuid' => $contact->uuid,
                    'content_uuid' => $content->uuid,
                ]);
            }
        }
    }
}
