<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class AddPAndPFranceContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('p_and_p_france');

        $this->getBridge()?->contentTypeDeleteField('node', 'p_and_p', 'is_french');
        $this->getBridge()?->contentTypeDeleteField('node', 'p_and_p', 'reviewed');
        $this->finishUp();
    }
}
