<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class UpdatePermissibleContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $types = [
            'brands',
            'countries',
            'management_modes',
            'business_units',
            'profiles',
        ];

        foreach ($types as $type) {
            $this->getBridge()?->contentTypeUpdate($type, ['permissible' => false]);
        }
        $this->finishUp();
    }
}
