<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'business_units',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'fr' => 'Business units',
            'en' => 'Business units',
        ],
    ],
    'fields' => [
        [
            'name' => 'code',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Code',
                'en' => 'Code',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'regional_offices',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Bureaux régionaux',
                'en' => 'Regional offices',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['regional_offices'],
                'cardinality' => -1,
            ],
            'selectable_all' => false,
        ],
    ],
];
