<?php

declare(strict_types=1);

return [
    'custom_notifications' => function (&$data, $model, $notificationType, $action) {
        switch ($action) {
            case 'edit':
                if (! array_key_exists('steps', $data)) {
                    return;
                }

                $data['extra']['mail']['text'] = 'notifications.mail.workflow.approval.text';

                $type = class_to_type($model);
                if (in_array($type, ['p_and_p', 'p_and_p_france'])) {
                    $data['text'] = "notifications.workflow.$type.approval.text";
                    $data['extra']['mail']['subject'] = "pplh.mail.$type.approval.subject";
                    $data['extra']['mail']['text'] = "pplh.mail.$type.approval.content";
                    $data['extra']['mail']['buttonText'] = "pplh.mail.$type.button";
                }
                break;
            case 'accept':
                $type = class_to_type($model);
                if (in_array($type, ['p_and_p', 'p_and_p_france'])) {
                    $data['text'] = "notifications.workflow.$type.accepted.text";
                    $data['extra']['mail']['subject'] = "pplh.mail.$type.accepted.subject";
                    $data['extra']['mail']['text'] = "pplh.mail.$type.accepted.content";
                    $data['extra']['mail']['buttonText'] = "pplh.mail.$type.button";

                    if ($model->author === $data['to']) {
                        $data['text'] = "notifications.workflow.$type.accepted.author.text";
                    }

                    break;
                }

                if ($model->author === $data['to']) {
                    $data['extra']['mail']['text'] = 'notifications.mail.workflow.accepted.author.text';
                } else {
                    $data['extra']['mail']['text'] = 'notifications.mail.workflow.accepted.text';
                }

                break;
            case 'decline':
                $type = class_to_type($model);
                if (in_array($type, ['p_and_p', 'p_and_p_france'])) {
                    $data['text'] = "notifications.workflow.$type.declined.text";
                    $data['extra']['mail']['subject'] = "pplh.mail.$type.declined.committee.subject";
                    $data['extra']['mail']['text'] = "pplh.mail.$type.declined.committee.content";
                    $data['extra']['mail']['buttonText'] = "pplh.mail.$type.button";
                }
                break;
        }
    },
];
