import { withFetch } from 'inside-collection/hocs'

import SpacePage from '../pages/spaces/SpacePage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import TabsSpacePage from '../pages/tabs_spaces/TabsSpacePage'

import { fetchSimpleSpace, fetchSpace, fetchTabsSpace } from '../fetch'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'NewsListingPage',
    props: {
      filtersInput: 'selectbox',
      extraCategoriesFields: [
        {
          countries: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ],
      itemsPerPage: 8,
      bannerData: { add: ['news', 'news_categories'] }
    },
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: ['weight:asc', 'title:asc']
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/users/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    component: () => import('../pages/map/MapPage'),
    meta: { disabled: false }
  },
  {
    name: 'SpacePage',
    path: {
      fr: '/espaces/:slug',
      en: '/spaces/:slug'
    },
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacesPagesPage',
    path: {
      fr: '/spaces/pages/:slug',
      en: '/spaces/pages/:slug'
    },
    alias: ['/fr/spaces/:slug/pages', '/en/spaces/:slug/pages'],
    component: withFetch(SpacesPagesPage, { size: 'xxl', watch: true })(
      fetchSimpleSpace
    ),
    meta: { content: 'spaces' }
  },
  {
    name: 'TabsSpacePage',
    path: {
      fr: '/espaces-onglet/pages/:slug',
      en: '/tabs-spaces/pages/:slug'
    },
    alias: ['/fr/espaces-onglet/:slug/pages', '/en/tabs-spaces/:slug/pages'],
    component: withFetch(TabsSpacePage, { size: 'xxl', watch: true })(
      fetchTabsSpace
    ),
    meta: { content: 'tab_spaces', disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  },
  {
    name: 'AdminAdvancedSettingsAutomaticTranslationPage',
    meta: { admin: true, display: true }
  }
]
