export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'outlook',
        label: 'Outlook'
      }
    ]
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true,
    liveTranslate: {
      enabled: true
    }
  },
  'inside-ged': {
    liveTranslate: {
      enabled: true
    }
  },
  'inside-layouts': {
    addContentTypes: {
      homepage: ['news', 'marker', 'events', 'movements']
    }
  },
  'inside-news': {
    liveTranslate: {
      enabled: true
    }
  },
  'inside-users': {
    bookmarkEnabled: true,
    bookmarkProfilContentTypes: ['news'],
    shortcuts: {
      max: 6
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'phone',
          'email',
          'content_type',
          { reactions: ['count', { users: ['uuid'] }] },
          { functions: ['uuid', 'title'] },
          { countries: ['uuid', 'title'] }
        ]
      }
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-paragraphs': {
    fetchedContents: {
      availabledContentTypes: ['news', 'tools', 'users', 'events', 'documents']
    }
  }
}
