import imageUsersListingBlock1Column from '@inside-users/assets/img/custom-page/imageUsersListingBlock1Column.png'

export const availableComponents = (t, app) => [
  {
    component: 'UsersListingBlock',
    label: t('customs.HOMEPAGE.usersListingBlock.label'),
    image: imageUsersListingBlock1Column,
    options: {
      pagination: { value: false },
      blockOptions: {
        title: {
          type: 'text',
          value: t('customs.HOMEPAGE.usersListingBlock.title'),
          title: t('users.CUSTOM_PAGE.usersListingBlock.options.title.title')
        },
        titleOptions: {
          type: 'radio',
          value: { alignment: 'center' },
          title: t(
            'users.CUSTOM_PAGE.usersListingBlock.options.titleOptions.title'
          ),
          options: [
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleOptions.left'
              ),
              value: { alignment: 'left' }
            },
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleOptions.center'
              ),
              value: { alignment: 'center' }
            },
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleOptions.right'
              ),
              value: { alignment: 'right' }
            }
          ],
          rules: ['required']
        },
        titleTag: {
          type: 'selectbox',
          value: 'h3',
          title: t(
            'users.CUSTOM_PAGE.usersListingBlock.options.titleTag.title'
          ),
          inputData: [
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleTag.h1'
              ),
              value: 'h1'
            },
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleTag.h2'
              ),
              value: 'h2'
            },
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleTag.h3'
              ),
              value: 'h3'
            },
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleTag.h4'
              ),
              value: 'h4'
            },
            {
              label: t(
                'users.CUSTOM_PAGE.usersListingBlock.options.titleTag.h5'
              ),
              value: 'h5'
            }
          ],
          multiple: false
        },
        link: {
          type: 'link',
          value: t('customs.HOMEPAGE.usersListingBlock.link'),
          title: t('users.CUSTOM_PAGE.usersListingBlock.options.link.title'),
          help: t('users.CUSTOM_PAGE.usersListingBlock.options.link.help')
        },
        linkLabel: {
          type: 'text',
          value: t(
            'users.CUSTOM_PAGE.usersListingBlock.options.linkLabel.value'
          ),
          title: t(
            'users.CUSTOM_PAGE.usersListingBlock.options.linkLabel.title'
          )
        },
        darkMode: {
          type: 'onoff',
          value: false,
          label: t('users.CUSTOM_PAGE.usersListingBlock.options.darkMode.label')
        }
      },
      extraFilters: {
        'uuid:in': {
          type: 'selectbox',
          endpoint: 'users',
          fields: ['firstname', 'lastname', 'uuid'],
          filters: {
            'is_maintenance:eq': 0,
            'status:eq': 1,
            sort: 'lastname:asc'
          },
          useUuidFilter: true,
          labelCallback: item => app.config.globalProperties.$_username(item),
          value: [],
          title: t('users.CUSTOM_PAGE.usersListingBlock.options.uuidIn.title'),
          help: t('users.CUSTOM_PAGE.usersListingBlock.options.uuidIn.help')
        }
      },
      itemsPerPage: {
        type: 'number',
        value: 4,
        title: t(
          'users.CUSTOM_PAGE.usersListingBlock.options.itemsPerPage.title'
        ),
        rules: ['required']
      },
      fractions: {
        value: 1
      }
    },
    layouts: [
      { layout: 2 },
      { layout: 3 },
      { layout: 5, requiredRatio: 3 },
      { layout: 6, requiredRatio: 3 },
      { layout: 7 },
      { layout: 8 },
      { layout: 9 },
      { layout: 10 }
    ]
  }
]

export const componentImport = {
  UsersListingBlock: () =>
    import('@inside-customs/components/home/HomeUsersListing')
}
