import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: async data => ({
      name: 'Homepage'
    })
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: pages } = await http.get('content/spaces_pages', {
        fields: [{ pages_categories: [{ spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: { slug: pages[0]?.pages_categories.spaces.slug[0] },
        query: { page: data.uuid }
      }
    },
    delete: async data => {
      const { data: pages } = await http.get('content/spaces_pages', {
        fields: [{ pages_categories: [{ spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: pages[0].pages_categories.spaces.slug[0] }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [{ spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async data => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [{ spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'SpacePage',
        params: { slug: pagesCategories[0].spaces.slug[0] }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [{ spaces: ['slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  tabSpaces: {
    add: ({ data }) => ({
      name: 'TabsSpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  groupingTabPages: {
    add: async ({ data }) => {
      const { data: groupingTabPages } = await http.get(
        'content/grouping_tab_pages',
        {
          fields: [{ tab_spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'TabsSpacePage',
        params: {
          slug: groupingTabPages[0].tab_spaces.slug[0]
        }
      }
    },
    delete: async data => {
      const { data: groupingTabPages } = await http.get(
        'content/grouping_tab_pages',
        {
          fields: [{ tab_spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'TabsSpacePage',
        params: {
          slug: groupingTabPages[0].tab_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: groupingTabPages } = await http.get(
        'content/grouping_tab_pages',
        {
          fields: [{ tab_spaces: { fields: ['slug'] } }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabsSpacePage',
          params: {
            slug: groupingTabPages[0].tab_spaces.slug[0]
          }
        }
      }
    }
  },
  tabBusinessPages: {
    add: async ({ data }) => {
      const { data: pages } = await http.get('content/tab_business_pages', {
        fields: [{ grouping_tab_pages: [{ tab_spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacePage',
        params: { slug: pages[0]?.grouping_tab_pages.tab_spaces.slug[0] },
        query: { page: data.uuid }
      }
    },
    delete: async data => {
      const { data: pages } = await http.get('content/tab_business_pages', {
        fields: [{ grouping_tab_pages: [{ tab_spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacePage',
        params: { slug: pages[0]?.grouping_tab_pages.tab_spaces.slug[0] }
      }
    }
  }
}
