import { http } from '@inside-library/helpers/Http'

const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        {
          users: {
            fields: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'functions',
              'phone',
              'content_type',
              { reactions: ['count', { users: ['uuid'] }] }
            ],
            filters: {
              'status:eq': 1,
              limit: 3
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'has_section',
              'admin',
              'content_type',
              'published_at'
            ],
            filters: { 'status:eq': 1, limit: 3 }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSimpleSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchTabsSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tab_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpace, fetchSimpleSpace, fetchTabsSpace }
