<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;

class AddedDefaultTools extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $defaultTools = [
            ['title' => 'Kelio', 'link' => 'https://groupepetitforestier.bodet-software.com/open/saml/SSO'],
            ['title' => 'Greenday', 'link' => 'https://wd3.myworkday.com/greenday/d/home.htmld'],
            ['title' => 'Cool Learning', 'link' => 'https://formation.petitforestier.com/Account/loginChoice?rt=Lw=='],
            ['title' => 'Helpdesk', 'link' => 'https://petitforestier.service-now.com/services'],
            ['title' => 'Greenforce', 'link' => 'https://greenforce.my.salesforce.com'],
            ['title' => 'Igloo', 'link' => 'http://igloo.petitforestier.fr'],

        ];

        $locale = config('app.locale');
        $bridgeContent = new BridgeContent();
        $toolsUuids = collect($defaultTools)->map(function ($tool) use ($locale, $bridgeContent) {
            $uuid = $bridgeContent->contentInsert('tools', [
                'langcode' => $locale,
                'title' => $tool['title'],
                'tools_link' => $tool['link'],
            ]);

            $main = Tools::find($uuid);
            collect(list_languages())->diff([$locale])->map(function ($language) use ($tool, $bridgeContent, $main) {
                $bridgeContent->contentInsert('tools', [
                    'langcode' => $language,
                    'uuid_host' => $main->uuid_host,
                    'title' => $tool['title'],
                    'tools_link' => $tool['link'],
                ]);
            });

            return ['uuid' => $uuid, 'uuid_host' => $main->uuid_host];
        });

        $bridgeContentType = new BridgeContentType();
        Users::each(function (Users $user) use ($bridgeContent, $toolsUuids) {
            $bridgeContent->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $toolsUuids->pluck('uuid')->all(),
            ]);
        });
        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $toolsUuids->pluck('uuid_host')->map(fn (string $uuid) => ['target_uuid' => $uuid])->all(),
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
