<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'grouping_tab_pages',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Regroupement de page à onglet',
            'en' => 'Grouping tab pages',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon_color',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Couleur de l\'icône',
                'en' => 'Icon color',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will go up as a banner from the block',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tab_spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Espace à onglet',
                'en' => 'Tab Space',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle le regroupement doit remonter',
                'en' => 'Choice of the space in which the grouping must go up',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tab_spaces'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'order of appearance',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
