<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => false,
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/peti-back/resources/assets/img/newsletter/bg.jpeg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA9675',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#EA9675',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#EA9675',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#EA9675'
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#000000',
        'links' => [
            'facebook' => [
                'url' => "https://www.facebook.com/PetitForestier",
            ],
            'twitter' => [
                'url' => "https://twitter.com/PetitForestier",
            ],
            'linkedin' => [
                'url' => "https://www.linkedin.com/company/1102009?trk=tyah ",
            ],
            'youtube' => [
                'url' => "https://www.youtube.com/@PetitForestierGroup",
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
