<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateUsers extends Migration
{
    use CreateContentTypes;
    public function up(): void
    {
        $this->bootUp(__FILE__);
        // Add new content types
        $this->migrateContent('services');
        $this->migrateContent('offices');
        $this->migrateContent('companies');
        $this->migrateContent('countries', false);
        $this->migrateContent('users', false);
        $this->call('models:rebuild');
        $this->finishUp();
    }
    public function down(): void
    {
    }
}
