<?php

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->department)))
            ->get(),
        'offices' => fn (mixed $user) => reference('offices')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->officeLocation)))
            ->get(),
        'companies' => fn (mixed $user) => reference('companies')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->companyName)))
            ->get(),
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? null,
        'mobile' => 'mobilePhone',
        'street' => 'streetAddress',
        'city' => 'city',
        'zip_code' => 'postalCode',
        'countries' => fn (mixed $user) => reference('countries')
            ->identifiedBy('code')
            ->from(trim($user->country))
            ->get(),
        'image' => 'photo',
        'status' => fn () => 1,
    ],
    'custom_attributes' => [
    ],
];
