export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'function',
      'email',
      'phone',
      'mobile_phone',
      'etage',
      'loisirs',
      'seniority_anniversary',
      'teams',
      'linkedin',
      'initials',
      {
        directions: { fields: ['title', 'uuid'], filters: { 'status:eq': 1 } }
      },
      {
        localisations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        hubs: { fields: ['title', 'uuid'], filters: { 'status:eq': 1 } }
      },
      {
        managers: {
          fields: [
            'uuid',
            'firstname',
            'lastname',
            'function',
            {
              localisations: {
                fields: ['uuid', 'title'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'status:eq': 1, 'is_maintenance:eq': 0 }
        }
      },
      {
        'users.managers': {
          fields: [
            'uuid',
            'firstname',
            'lastname',
            'function',
            {
              localisations: {
                fields: ['uuid', 'title'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            alias: 'coworkers'
          }
        }
      }
    ]
  }
}
