import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    gdprContent: 'popins'
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'function',
          { localisations: ['title'] }
        ]
      }
    }
  }
}
