<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class DeleteWorkBirthdayForOrsy extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect(list_languages())->each(function ($lang) use ($bridge) {
            $adsCustomPage = type_to_class('custom')::query()
                ->where('custom_slug', 'work-anniversaries')
                ->where('langcode', $lang)
                ->first();

            if (empty($adsCustomPage?->uuid)) {
                return;
            }

            $bridge->contentDelete(
                type: 'custom',
                uuid: $adsCustomPage?->uuid
            );
        });
    }
}
